#include <SFML/Graphics.hpp>
#include <Squared.hpp>

int main()
{
    sf::RenderWindow window(sf::VideoMode({400, 300}), "squared example");
    window.setFramerateLimit(60);
    
    squ::FrameAnimation animation;
    animation.loadFromFile("animation.sqv");

    squ::FrameAnimator animator;
    animator.setAnimation(&animation);
    animator.setFramesPerSecond(10);
    animator.setLoop(true);
    animator.play();

    sf::Clock delta;
    while (window.isOpen())
    {
        while (auto event = window.pollEvent())
        {
            if (event->is<sf::Event::Closed>())
                window.close();
        }
        animator.update(delta.restart());

        window.clear();
        window.draw(animator);
        window.display();
    }

    return 0;
}